"use strict";
exports.ro = void 0;
var _index = require("./ro/_lib/formatDistance.cjs");
var _index2 = require("./ro/_lib/formatLong.cjs");
var _index3 = require("./ro/_lib/formatRelative.cjs");
var _index4 = require("./ro/_lib/localize.cjs");
var _index5 = require("./ro/_lib/match.cjs");

/**
 * @category Locales
 * @summary Romanian locale.
 * @language Romanian
 * @iso-639-2 ron
 * @author Sergiu Munteanu [@jsergiu](https://github.com/jsergiu)
 * @author Adrian Ocneanu [@aocneanu](https://github.com/aocneanu)
 * @author Mihai Ocneanu [@gandesc](https://github.com/gandesc)
 */
const ro = (exports.ro = {
  code: "ro",
  formatDistance: _index.formatDistance,
  formatLong: _index2.formatLong,
  formatRelative: _index3.formatRelative,
  localize: _index4.localize,
  match: _index5.match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 1,
  },
});
