import { mailProvider } from "../lib/mail";
import {
  emailAddedNotificationTemplate,
  emailCompleteExchangeTemplate,
  TEmailCompleteExchange,
} from "../templates/email/exchanges";

interface Email {
  email: string;
  password: string;
}

class MailService {
  sendCompleteExchange = async (to: string, data: TEmailCompleteExchange) => {
    await mailProvider.send(to, emailCompleteExchangeTemplate(data));
  };
  notifyAddedEmail = async (
    to: string,
    { email, name }: { email: string; name: string }
  ) => {
    await mailProvider.send(to, emailAddedNotificationTemplate(email, name));
  };
}

export const mailService = new MailService();
